<?php
	/*	
	*	Goodlayers Framework File
	*	---------------------------------------------------------------------
	*	This file contains the homepage loading button in page option area
	*	---------------------------------------------------------------------
	*/
	
	add_action('add_meta_boxes', 'gdlr_init_demo_page_option');
	if( !function_exists('gdlr_init_demo_page_option') ){
		function gdlr_init_demo_page_option(){
			add_meta_box( 'demo-page-option', 
				__('Load Demo Page', 'gdlr_translate'), 
				'gdlr_create_demo_page_option',
				'page',
				'side',
				'default'
			);
		}
	}
	
	if( !function_exists('gdlr_create_demo_page_option') ){
		function gdlr_create_demo_page_option(){
			global $post;
		
			$buttons = array(
				'homepage-1' => __('Homepage', 'gdlr_translate'),
				'homepage-2' => __('Homepage Layer Slider', 'gdlr_translate'),
				'homepage-3' => __('Homepage Post Slider', 'gdlr_translate'),
				'our-story' => __('Our Story', 'gdlr_translate'),
				'what-we-do' => __('What We Do', 'gdlr_translate'),
				'be-a-volunteer' => __('Be a Volunteer', 'gdlr_translate'),
				'faq' => __('FAQ', 'gdlr_translate'),
				'service' => __('Service', 'gdlr_translate'),
				'contact-1' => __('Contact 1', 'gdlr_translate'),
				'contact-2' => __('Contact 2', 'gdlr_translate'),
			);
			
			echo '<div id="gdlr-load-demo-wrapper" data-ajax="' . AJAX_URL . '" data-id="' . $post->ID . '" data-action="load_demo_pagebuilder">';
			echo '<em>';
			echo __('*This option allow you to set page item to following pages with one click. Note that to use this option will replace all your current page item setting in this page and <strong>This Can\'t Be Undone</strong>. ( Images are not included. )', 'gdlr_translate');
			echo '</em><div class="clear"></div>';
			foreach( $buttons as $button_slug => $button_title ){
				echo '<input type="button" data-slug="' . $button_slug . '" value="' . $button_title . '" />';
			}
			echo '</div>';

		}
	}
	
	add_action('wp_ajax_load_demo_pagebuilder', 'gdlr_load_demo_pagebuilder');
	if( !function_exists('gdlr_load_demo_pagebuilder') ){
		function gdlr_load_demo_pagebuilder(){
			$default_data = array(
				'homepage-1' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Post/Cause Slider","type":"post-slider","option":{"page-item-id":"","post-type":"cause","category":"fit-row","cause-category":"cause-slider","num-excerpt":"31","num-fetch":"3","thumbnail-size":"post-slider-side","caption-style":"post-right post-slider","orderby":"date","order":"desc","margin-bottom":"0px"}}],"option":{"page-item-id":"","background":"#f3f3f3","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"34px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Styled Box","type":"styled-box","option":{"page-item-id":"","type":"image","flip-corner":"disable","background-color":"#9ada55","corner-color":"#3d6817","content-color":"#ffffff","background-image":"2840","icon":"","title":"Who are we?","caption":"Story About Us","content":"Curabitur blandit tempus porttitor. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Nullam quis risus eget urna mollis ornare vel eu leo t non mi porta gravida at eget metus. <br/><br/> <a href=|gq2|http://themes.goodlayers2.com/charityhub/our-story/|gq2|>Learn More</a>","margin-bottom":"0px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Urgent Cause","type":"urgent-cause","option":{"page-item-id":"","title":"Urgent Cause","cause":"stop-syrias-hunger","num-excerpt":"40","min-height":"","margin-bottom":"0px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","background":"#ffffff","skin":"gdlr-skin-urgent-cause","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"30px","padding-bottom":"0px"}},{"item-type":"item","item-builder-title":"Cause","type":"cause","option":{"page-item-id":"","title-type":"left","icon":"icon-eye-open","title":"Cause List","caption":"","right-text":"View All Causes","right-text-link":"#","category":"causes","cause-style":"grid","cause-size":"1/4","cause-layout":"carousel","num-fetch":"7","num-excerpt":"15","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"2/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Feature Media","type":"feature-media","option":{"page-item-id":"","type":"none","video-url":"","image":"","thumbnail-size":"thumbnail","title":"We need your help","caption":"Let\'s Stop This hunger and fullfill their happiness","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean lacinia bibendum nulla sed consectetur. Cras mattis consectetur purus sit amet fermentum. Cras justo odio, dapibus ac facilisisAenean eu leo quam. Pellentesque ornare sem lacinia quam...","button-text":"Learn More","button-link":"#","margin-bottom":"20px"}}],"option":{},"size":"3/5"}],"option":{"page-item-id":"","type":"image","background":"2855","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-dark-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"110px","padding-bottom":"60px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Cause Search","type":"cause-search","option":{"page-item-id":"","title":"Search For Causes","caption":"Please fill keywords in text box and select particular category to search for all causes.","margin-bottom":"58px"}},{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","icon":"icon-file-text-alt","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"#","category":"fit-row","tag":"","num-excerpt":"20","num-fetch":"5","blog-style":"blog-1-3","blog-layout":"carousel","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","enable-sticky":"enable","margin-bottom":"0px"}},{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"left","icon":"icon-picture","title":"Gallery (By Portfolio)","caption":"","right-text":"View All Works","right-text-link":"","category":"homepage","tag":"","portfolio-style":"modern-portfolio","num-fetch":"8","portfolio-size":"1/3","portfolio-layout":"carousel","portfolio-filter":"disable","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"50px"}}],"option":{},"size":"2/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Styled Box","type":"styled-box","option":{"page-item-id":"","type":"color","flip-corner":"disable","background-color":"#f37936","corner-color":"#e87e33","content-color":"#ffffff","background-image":"","icon":"icon-bullhorn","title":"Become Volunteer","caption":"We Need You!","content":"Become a part of our family. Together, we|g1n|can save many lives and stop this hunger.|g1n||g1n|[gdlr_button href=|gq2|http://themes.goodlayers2.com/charityhub/be-a-volunteer/|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#ffffff|gq2| color=|gq2|#e87e33|gq2|]Apply Now![/gdlr_button]|g1n||g1n|[gdlr_space height=|gq2|-13px|gq2|]","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Subscribe To Newsletter","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_space height=|gq2|-10px|gq2|]|g1n||g1n|Stay informed on new causes and up-coming organization updates. Don\'t miss things!|g1n||g1n|[wysija_form id=|gq2|1|gq2|]","margin-bottom":"45px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Video Campaign","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"0px"}},{"item-type":"item","item-builder-title":"Video","type":"video","option":{"page-item-id":"","url":"http://vimeo.com/86823427","margin-bottom":"50px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2879|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Yasser Hadman|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Syria|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla |g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2880|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Abebe Ja|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit |g2n|amet risus. Sed posuere consectetur est at lobortis. Cras mattis consectetur purus sit amet fermentum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2881|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jabarl Yos|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla |g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|}]","title-type":"center","icon":"","title":"Words from children in our program","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2878","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"40px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-2' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Layer Slider","type":"layer-slider","option":{"page-item-id":"","id":"1","margin-bottom":"20px"}}],"option":{"page-item-id":"","border":"","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"0px","padding-bottom":"40px"}}]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Styled Box","type":"styled-box","option":{"page-item-id":"","type":"image","flip-corner":"disable","background-color":"#9ada55","corner-color":"#3d6817","content-color":"#ffffff","background-image":"2840","icon":"","title":"Who are we?","caption":"Story About Us","content":"Curabitur blandit tempus porttitor. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Nullam quis risus eget urna mollis ornare vel eu leo t non mi porta gravida at eget metus. <br/><br/> <a href=|gq2|http://themes.goodlayers2.com/charityhub/our-story/|gq2|>Learn More</a>","margin-bottom":"0px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Urgent Cause","type":"urgent-cause","option":{"page-item-id":"","title":"Urgent Cause","cause":"stop-syrias-hunger","num-excerpt":"40","min-height":"","margin-bottom":"0px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","background":"#ffffff","skin":"gdlr-skin-urgent-cause","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"30px","padding-bottom":"0px"}},{"item-type":"item","item-builder-title":"Cause","type":"cause","option":{"page-item-id":"","title-type":"left","icon":"icon-eye-open","title":"Cause List","caption":"","right-text":"View All Causes","right-text-link":"#","category":"causes","cause-style":"grid","cause-size":"1/4","cause-layout":"carousel","num-fetch":"7","num-excerpt":"15","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"2/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Feature Media","type":"feature-media","option":{"page-item-id":"","type":"none","video-url":"","image":"","thumbnail-size":"thumbnail","title":"We need your help","caption":"Let\'s Stop This hunger and fullfill their happiness","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean lacinia bibendum nulla sed consectetur. Cras mattis consectetur purus sit amet fermentum. Cras justo odio, dapibus ac facilisisAenean eu leo quam. Pellentesque ornare sem lacinia quam...","button-text":"Learn More","button-link":"#","margin-bottom":"20px"}}],"option":{},"size":"3/5"}],"option":{"page-item-id":"","type":"image","background":"2855","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-dark-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"110px","padding-bottom":"60px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Cause Search","type":"cause-search","option":{"page-item-id":"","title":"Search For Causes","caption":"Please fill keywords in text box and select particular category to search for all causes.","margin-bottom":"58px"}},{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","icon":"icon-file-text-alt","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"#","category":"fit-row","tag":"","num-excerpt":"20","num-fetch":"5","blog-style":"blog-1-3","blog-layout":"carousel","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","enable-sticky":"enable","margin-bottom":"0px"}},{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"left","icon":"icon-picture","title":"Gallery (By Portfolio)","caption":"","right-text":"View All Works","right-text-link":"","category":"homepage","tag":"","portfolio-style":"modern-portfolio","num-fetch":"8","portfolio-size":"1/3","portfolio-layout":"carousel","portfolio-filter":"disable","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"50px"}}],"option":{},"size":"2/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Styled Box","type":"styled-box","option":{"page-item-id":"","type":"color","flip-corner":"disable","background-color":"#f37936","corner-color":"#e87e33","content-color":"#ffffff","background-image":"","icon":"icon-bullhorn","title":"Become Volunteer","caption":"We Need You!","content":"Become a part of our family. Together, we|g1n|can save many lives and stop this hunger.|g1n||g1n|[gdlr_button href=|gq2|http://themes.goodlayers2.com/charityhub/be-a-volunteer/|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#ffffff|gq2| color=|gq2|#e87e33|gq2|]Apply Now![/gdlr_button]|g1n||g1n|[gdlr_space height=|gq2|-13px|gq2|]","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Subscribe To Newsletter","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_space height=|gq2|-10px|gq2|]|g1n||g1n|Stay informed on new causes and up-coming organization updates. Don\'t miss things!|g1n||g1n|[wysija_form id=|gq2|1|gq2|]","margin-bottom":"45px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Video Campaign","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"0px"}},{"item-type":"item","item-builder-title":"Video","type":"video","option":{"page-item-id":"","url":"http://vimeo.com/86823427","margin-bottom":"50px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2879|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Yasser Hadman|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Syria|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla |g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2880|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Abebe Ja|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit |g2n|amet risus. Sed posuere consectetur est at lobortis. Cras mattis consectetur purus sit amet fermentum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2881|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jabarl Yos|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla |g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|}]","title-type":"center","icon":"","title":"Words from children in our program","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2878","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"40px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'homepage-3' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Post/Cause Slider","type":"post-slider","option":{"page-item-id":"","post-type":"post","category":"fit-row","cause-category":"cause-slider","num-excerpt":"31","num-fetch":"3","thumbnail-size":"post-slider-side","caption-style":"post-right post-slider","orderby":"date","order":"desc","margin-bottom":"0px"}}],"option":{"page-item-id":"","background":"#f3f3f3","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"34px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Styled Box","type":"styled-box","option":{"page-item-id":"","type":"image","flip-corner":"disable","background-color":"#9ada55","corner-color":"#3d6817","content-color":"#ffffff","background-image":"2840","icon":"","title":"Who are we?","caption":"Story About Us","content":"Curabitur blandit tempus porttitor. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Nullam quis risus eget urna mollis ornare vel eu leo t non mi porta gravida at eget metus. <br/><br/> <a href=|gq2|http://themes.goodlayers2.com/charityhub/our-story/|gq2|>Learn More</a>","margin-bottom":"0px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Urgent Cause","type":"urgent-cause","option":{"page-item-id":"","title":"Urgent Cause","cause":"stop-syrias-hunger","num-excerpt":"40","min-height":"","margin-bottom":"0px"}}],"option":{},"size":"2/3"}],"option":{"page-item-id":"","background":"#ffffff","skin":"gdlr-skin-urgent-cause","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"30px","padding-bottom":"0px"}},{"item-type":"item","item-builder-title":"Cause","type":"cause","option":{"page-item-id":"","title-type":"left","icon":"icon-eye-open","title":"Cause List","caption":"","right-text":"View All Causes","right-text-link":"#","category":"causes","cause-style":"grid","cause-size":"1/4","cause-layout":"carousel","num-fetch":"7","num-excerpt":"15","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[],"option":{},"size":"2/5"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Feature Media","type":"feature-media","option":{"page-item-id":"","type":"none","video-url":"","image":"","thumbnail-size":"thumbnail","title":"We need your help","caption":"Let\'s Stop This hunger and fullfill their happiness","content":"Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aenean lacinia bibendum nulla sed consectetur. Cras mattis consectetur purus sit amet fermentum. Cras justo odio, dapibus ac facilisisAenean eu leo quam. Pellentesque ornare sem lacinia quam...","button-text":"Learn More","button-link":"#","margin-bottom":"20px"}}],"option":{},"size":"3/5"}],"option":{"page-item-id":"","type":"image","background":"2855","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-dark-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"110px","padding-bottom":"60px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Cause Search","type":"cause-search","option":{"page-item-id":"","title":"Search For Causes","caption":"Please fill keywords in text box and select particular category to search for all causes.","margin-bottom":"58px"}},{"item-type":"item","item-builder-title":"Blog","type":"blog","option":{"page-item-id":"","title-type":"left","icon":"icon-file-text-alt","title":"Recent News","caption":"","right-text":"Read All News","right-text-link":"#","category":"fit-row","tag":"","num-excerpt":"20","num-fetch":"5","blog-style":"blog-1-3","blog-layout":"carousel","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","enable-sticky":"enable","margin-bottom":"0px"}},{"item-type":"item","item-builder-title":"Portfolio","type":"portfolio","option":{"page-item-id":"","title-type":"left","icon":"icon-picture","title":"Gallery (By Portfolio)","caption":"","right-text":"View All Works","right-text-link":"","category":"homepage","tag":"","portfolio-style":"modern-portfolio","num-fetch":"8","portfolio-size":"1/3","portfolio-layout":"carousel","portfolio-filter":"disable","thumbnail-size":"small-grid-size","orderby":"date","order":"desc","pagination":"disable","margin-bottom":"50px"}}],"option":{},"size":"2/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column2-3","items":[{"item-type":"item","item-builder-title":"Styled Box","type":"styled-box","option":{"page-item-id":"","type":"color","flip-corner":"disable","background-color":"#f37936","corner-color":"#e87e33","content-color":"#ffffff","background-image":"","icon":"icon-bullhorn","title":"Become Volunteer","caption":"We Need You!","content":"Become a part of our family. Together, we|g1n|can save many lives and stop this hunger.|g1n||g1n|[gdlr_button href=|gq2|http://themes.goodlayers2.com/charityhub/be-a-volunteer/|gq2| target=|gq2|_self|gq2| size=|gq2|medium|gq2| background=|gq2|#ffffff|gq2| color=|gq2|#e87e33|gq2|]Apply Now![/gdlr_button]|g1n||g1n|[gdlr_space height=|gq2|-13px|gq2|]","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Subscribe To Newsletter","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_space height=|gq2|-10px|gq2|]|g1n||g1n|Stay informed on new causes and up-coming organization updates. Don\'t miss things!|g1n||g1n|[wysija_form id=|gq2|1|gq2|]","margin-bottom":"45px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Video Campaign","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"0px"}},{"item-type":"item","item-builder-title":"Video","type":"video","option":{"page-item-id":"","url":"http://vimeo.com/86823427","margin-bottom":"50px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2879|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Yasser Hadman|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Syria|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla |g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2880|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Abebe Ja|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit |g2n|amet risus. Sed posuere consectetur est at lobortis. Cras mattis consectetur purus sit amet fermentum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2881|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jabarl Yos|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla |g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|}]","title-type":"center","icon":"","title":"Words from children in our program","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2878","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"40px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'our-story' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_heading tag=|gq2|h1|gq2| size=|gq2|60px|gq2| font_weight=|gq2|700|gq2|]Our Story[/gdlr_heading]|g1n||g1n|[gdlr_heading tag=|gq2|h3|gq2| size=|gq2|32px|gq2| font_weight=|gq2|400|gq2|]Who We Are.[/gdlr_heading]","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2906","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"125px","padding-bottom":"75px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Feature Media","type":"feature-media","option":{"page-item-id":"","type":"video","video-url":"http://vimeo.com/86823427","image":"","thumbnail-size":"thumbnail","title":"Video About Our Story","caption":"","content":"Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Etiam porta sem malesuada magna mollis euismod. Vestibulum id ligula porta felis euismod semper. Vestibulum id ligula porta felis euismod semper. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nullam id dolor id nibh ultricies vehicula ut id elit. Donec sed odio dui. Nulla vitae elit libero.","button-text":"Learn More","button-link":"#","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"35px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-2","icon":"icon-time","image":"","thumbnail-size":"","title":"Amet Pellentesque Tristique","content":"Cras mattis consectetur purus sit amet fermentum. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque.","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-2","icon":"icon-heart-empty","image":"","thumbnail-size":"","title":"Purus Sem Pharetra","content":"Cras mattis consectetur purus sit amet fermentum. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque.","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-2","icon":"icon-flag","image":"","thumbnail-size":"","title":"Consectetur Ridiculus","content":"Cras mattis consectetur purus sit amet fermentum. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Cum sociis natoque.","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background":"#f5f5f5","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","title":"Adipiscing Fringilla Ipsum Fermentum ","caption":"Cras justo odio, dapibus ac facilisis in, egestas eget quam. Maecenas sed diam eget risus varius blandit sit amet non |g1n|magna. Sed posuere consectetur est at lobortis. Sed posuere consectetur est at lobortis. Fusce dapibus, tellus ac cursus |g1n|commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.","button-text":"Donate Now","button-link":"#","style":"center","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2891","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"105px","padding-bottom":"60px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Personnel","type":"personnel","option":{"page-item-id":"","personnel":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2013/11/personnel-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2766|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Doe|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Organization Founder|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Curabitur blandit tempus porttitor. Sed posuere consectetur est at lobortis. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Donec ullamcorper nulla non metus auctor.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|icon-facebook-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-twitter-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-linkedin-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-skype|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-dribbble|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2013/11/personnel-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2767|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Susan Caveman|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Team Manager|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Curabitur blandit tempus porttitor. Sed posuere consectetur est at lobortis. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Donec ullamcorper nulla non metus auctor.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|icon-facebook-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-twitter-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-linkedin-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-skype|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-dribbble|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|]|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2013/11/personnel-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2768|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jack Justin|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Social Manager|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Curabitur blandit tempus porttitor. Sed posuere consectetur est at lobortis. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Donec ullamcorper nulla non metus auctor.|gq2|,|gq2|gdl-tab-social-list|gq2|:|gq2|[gdlr_icon type=|gq6|icon-facebook-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-twitter-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-linkedin-sign|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-skype|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|] [gdlr_icon type=|gq6|icon-dribbble|gq6| size=|gq6|22px|gq6| color=|gq6|#222|gq6|]|gq2|}]","title-type":"icon","icon":"","title":"Meet The Team","caption":"","personnel-columns":"3","personnel-type":"static","personnel-style":"plain-style","thumbnail-size":"full","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"0px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Tabs Content","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Tab","type":"tab","option":{"page-item-id":"","tab":"[{|gq2|gdl-tab-title|gq2|:|gq2|Inceptos Dolor|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Maecenas faucibus mollis interdum. Nullam id dolor id nibh ultricies vehicula ut id elit. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Consectetur Ipsum|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Maecenas faucibus mollis interdum. Nullam id dolor id nibh ultricies vehicula ut id elit. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Quam Adipiscing|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Maecenas faucibus mollis interdum. Nullam id dolor id nibh ultricies vehicula ut id elit. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec ullamcorper nulla non metus auctor fringilla. Donec ullamcorper nulla non metus auctor fringilla.|gq2|}]","initial-state":"1","style":"horizontal","title-type":"none","icon":"","title":"","caption":"","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Statistic","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Success Rate","percent":"95","size":"small","icon":"","text-color":"#494949","background-color":"#e9e9e9","progress-color":"#62cdff","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Children From Africa","percent":"65","size":"small","icon":"","text-color":"#494949","background-color":"#e9e9e9","progress-color":"#62cdff","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Skill Bar","type":"skill-bar","option":{"page-item-id":"","content":"Children From Syria","percent":"75","size":"small","icon":"","text-color":"#494949","background-color":"#e9e9e9","progress-color":"#62cdff","margin-bottom":"20px"}}],"option":{},"size":"1/2"},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"","margin-bottom":"60px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'what-we-do' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_heading tag=|gq2|h1|gq2| size=|gq2|59px|gq2| font_weight=|gq2|700|gq2|]Our Top Mission...[/gdlr_heading]|g1n||g1n|[gdlr_heading tag=|gq2|h3|gq2| size=|gq2|31px|gq2| font_weight=|gq2|400|gq2|]is to help everyone and bring them a better life.[/gdlr_heading]","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2900","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"125px","padding-bottom":"75px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-heart-empty","image":"","thumbnail-size":"","title":"Pharetra Purus Quam","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Integer posuere erat a ante venenatis dapibus posuere.","margin-bottom":"40px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-eye-open","image":"","thumbnail-size":"","title":"Ridiculus Ullamcorper","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Integer posuere erat a ante venenatis dapibus posuere.","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-truck","image":"","thumbnail-size":"","title":"Adipiscing Fermentum","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Integer posuere erat a ante venenatis dapibus posuere.","margin-bottom":"40px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-trophy","image":"","thumbnail-size":"","title":"Ultricies Ullamcorper","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Integer posuere erat a ante venenatis dapibus posuere.","margin-bottom":"40px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-thumbs-up-alt","image":"","thumbnail-size":"","title":"Ornare Sollicitudin","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Integer posuere erat a ante venenatis dapibus posuere.","margin-bottom":"40px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-group","image":"","thumbnail-size":"thumbnail","title":"Lorem Condimentum","content":"Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Integer posuere erat a ante venenatis dapibus posuere.","margin-bottom":"40px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background":"#f5f5f5","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Feature Media","type":"feature-media","option":{"page-item-id":"","type":"image","video-url":"","image":"2904","thumbnail-size":"full","title":"For over a decade","caption":"We have been saving more than 10,000 lives","content":"Nullam id dolor id nibh ultricies vehicula ut id elit. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui. Nullam id dolor id nibh ultricies vehicula ut id elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Maecenas faucibus mollis interdum. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia.","button-text":"Learn More","button-link":"#","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"75px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","title":"Lives We Saved","caption":"","button-text":"Buy Now","button-link":"","style":"center","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#484848","skin":"gdlr-skin-dark-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"45px","padding-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Column","type":"skill-round","option":{"page-item-id":"","title":"2,000","caption":"Asian","text-color":"#5e5e5e"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Column","type":"skill-round","option":{"page-item-id":"","title":"4,000","caption":"African","text-color":"#5e5e5e"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Column","type":"skill-round","option":{"page-item-id":"","title":"3,000","caption":"South American","text-color":"#5e5e5e"}}],"option":{},"size":"1/4"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-4","items":[{"item-type":"item","item-builder-title":"Skill Column","type":"skill-round","option":{"page-item-id":"","title":"2,000","caption":"Syrian","text-color":"#5e5e5e"}}],"option":{},"size":"1/4"}],"option":{"page-item-id":"","background":"#f7f7f7","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"icon-eye-open","title":"How we help","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-image","icon":"","image":"2723","thumbnail-size":"small-grid-size","title":"Reunit Children With Family","content":"Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam id dolor id nibh ultricies vehicula ut id elit. Maecenas faucibus mollis.","margin-bottom":"40px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-image","icon":"","image":"3009","thumbnail-size":"small-grid-size","title":"Provide Knowledge","content":"Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam id dolor id nibh ultricies vehicula ut id elit. Maecenas faucibus mollis.","margin-bottom":"40px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-image","icon":"","image":"2718","thumbnail-size":"small-grid-size","title":"Provide Food","content":"Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam id dolor id nibh ultricies vehicula ut id elit. Maecenas faucibus mollis.","margin-bottom":"40px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-image","icon":"","image":"2745","thumbnail-size":"small-grid-size","title":"Health Is Matter","content":"Maecenas sed diam eget risus varius blandit sit amet non magna. Nullam id dolor id nibh ultricies vehicula ut id elit. Maecenas faucibus mollis.","margin-bottom":"40px"}}],"option":{},"size":"1/2"}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"80px","padding-bottom":"35px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","title":"Adipiscing Fringilla Ipsum Fermentum ","caption":"Cras mattis consectetur purus sit amet fermentum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus.","button-text":"Donate Now","button-link":"#","style":"center","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2905","background-speed":"0","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-stunning-what-we-do","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"50px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'be-a-volunteer' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_heading tag=|gq2|h1|gq2| size=|gq2|59px|gq2| font_weight=|gq2|700|gq2|]Be A Volunteer[/gdlr_heading]|g1n||g1n|[gdlr_heading tag=|gq2|h3|gq2| size=|gq2|31px|gq2| font_weight=|gq2|400|gq2|]We need you.[/gdlr_heading]","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2898","background-speed":"0.3","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-testimonial-hp","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"125px","padding-bottom":"75px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Service With Image","type":"service-with-image","option":{"page-item-id":"","image":"2897","thumbnail-size":"full","align":"left","title":"Who can apply the program?","content":"Donec ullamcorper nulla non metus auctor fringilla. Vestibulum id ligula porta felis euismod semper. Etiam porta sem malesuada magna mollis euismod. Aenean lacinia bibendum nulla sed consectetur. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor Praesent commodo cursus magna, vel.","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Service With Image","type":"service-with-image","option":{"page-item-id":"","image":"2895","thumbnail-size":"full","align":"right","title":"What is the benefits?","content":"Donec ullamcorper nulla non metus auctor fringilla. Vestibulum id ligula porta felis euismod semper. Etiam porta sem malesuada magna mollis euismod. Aenean lacinia bibendum nulla sed consectetur. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor Praesent commodo cursus magna, vel.","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#f5f5f5","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"70px","padding-bottom":"30px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Tabs Content","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}},{"item-type":"item","item-builder-title":"Tab","type":"tab","option":{"page-item-id":"","tab":"[{|gq2|gdl-tab-title|gq2|:|gq2|Maleda Conditum|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Donec ullamcorper nulla non metus auctor fringilla. Maecenas faucibus mollis interdum. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.|g2n||g2n|Vestibulum id ligula porta felis euismod semper. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Ornare Euismod|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Donec ullamcorper nulla non metus auctor fringilla. Maecenas faucibus mollis interdum. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.|g2n||g2n|Vestibulum id ligula porta felis euismod semper. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Ullamcorper Fusce|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Donec ullamcorper nulla non metus auctor fringilla. Maecenas faucibus mollis interdum. Nullam quis risus eget urna mollis ornare vel eu leo. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.|g2n||g2n|Vestibulum id ligula porta felis euismod semper. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Donec sed odio dui.|gq2|}]","initial-state":"1","style":"vertical","title-type":"none","icon":"","title":"","caption":"","margin-bottom":"20px"}}],"option":{},"size":"2/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-1.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2879|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Yadser Hadman|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Syria|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla|g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-2.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2880|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Abebe Ja|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit|g2n|amet risus. Sed posuere consectetur est at lobortis. Cras mattis consectetur purus sit amet fermentum.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2|http://themes.goodlayers2.com/charityhub/wp-content/uploads/2014/04/testimonial-hp-3.jpg|gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2|2881|gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Jabarl Yos|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Africa|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla|g2n|consectetur. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Duis mollis, est non commodo luctus.|gq2|}]","title-type":"left","icon":"","title":"Words From Children","caption":"","testimonial-columns":"1","testimonial-type":"carousel","testimonial-style":"round-style","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"0px"}},{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"How To Apply?","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"55px"}},{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_process min_height=|gq2|180px|gq2| type=|gq2|vertical|gq2| ]|g1n||g1n|[gdlr_tab icon=|gq2|icon-pencil|gq2| title=|gq2|Step 1: Vehicula Egestas Amet Fringilla|gq2| ]Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Qui ipsorum lingua Celtae, nostra Galli appellantur. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae. Contra legem facit qui id facit quod lex prohibet. Magna pars studiorum, prodita quaerimus. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae.[/gdlr_tab]|g1n||g1n|[gdlr_tab icon=|gq2|icon-file-text-alt|gq2| title=|gq2|Step 2:Nihilne Te Nocturnum Tempor|gq2| ]Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Qui ipsorum lingua Celtae, nostra Galli appellantur. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae. Contra legem facit qui id facit quod lex prohibet. Magna pars studiorum, prodita quaerimus. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae.[/gdlr_tab]|g1n||g1n|[gdlr_tab icon=|gq2|icon-check|gq2| title=|gq2|Step 3:Concilium Totius Galliae|gq2| ]Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Qui ipsorum lingua Celtae, nostra Galli appellantur. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae. Contra legem facit qui id facit quod lex prohibet. Magna pars studiorum, prodita quaerimus. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae.[/gdlr_tab]|g1n||g1n|[gdlr_tab icon=|gq2|icon-thumbs-up-alt|gq2| title=|gq2|Step 4:Concilium Totius Galliae|gq2| ]Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Qui ipsorum lingua Celtae, nostra Galli appellantur. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae. Contra legem facit qui id facit quod lex prohibet. Magna pars studiorum, prodita quaerimus. Nihilne te nocturnum praesidium Palati, nihil urbis vigiliae.[/gdlr_tab]|g1n||g1n|[/gdlr_process]","margin-bottom":"40px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"Footer 1","right-sidebar":"Footer 1","page-style":"normal","navigation-area":"top","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'faq' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"left","icon":"","title":"Please make sure that you finish FAQ below.","caption":"","right-text":"Read More","right-text-link":"","margin-bottom":"50px"}},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-truck","image":"","thumbnail-size":"","title":"Malesuada Tortor","content":"Sed posuere consectetur est at lobortis. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","margin-bottom":"30px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-heart-empty","image":"","thumbnail-size":"","title":"Aenean Consectetur","content":"Sed posuere consectetur est at lobortis. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","margin-bottom":"30px"}}],"option":{},"size":"1/2"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-eye-open","image":"","thumbnail-size":"","title":"Vulputate Ultricies","content":"Sed posuere consectetur est at lobortis. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","margin-bottom":"30px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-user","image":"","thumbnail-size":"","title":"Dapibus Commodo","content":"Sed posuere consectetur est at lobortis. Donec sed odio dui. Vestibulum id ligula porta felis euismod semper. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum.","margin-bottom":"60px"}}],"option":{},"size":"1/2"},{"item-type":"item","item-builder-title":"Accordion","type":"accordion","option":{"page-item-id":"","accordion":"[{|gq2|gdl-tab-title|gq2|:|gq2|Amet Vestibulum Bibendum|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Curabitur blandit tempus porttitor.|g2n||g2n|Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Cras mattis consectetur purus sit amet fermentum. Curabitur blandit tempus porttitor.|g2n||g2n|Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Curabitur blandit tempus porttitor. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Sollicitudin Quam Purus Inceptos|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Curabitur blandit tempus porttitor.|g2n||g2n|Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Cras mattis consectetur purus sit amet fermentum. Curabitur blandit tempus porttitor.|g2n||g2n|Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Curabitur blandit tempus porttitor. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Pellentesque Dapibus Sollicitudin Porta|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Curabitur blandit tempus porttitor.|g2n||g2n|Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Cras mattis consectetur purus sit amet fermentum. Curabitur blandit tempus porttitor.|g2n||g2n|Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Curabitur blandit tempus porttitor. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Inceptos Commodo Ridiculus|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Curabitur blandit tempus porttitor.|g2n||g2n|Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Cras mattis consectetur purus sit amet fermentum. Curabitur blandit tempus porttitor.|g2n||g2n|Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Curabitur blandit tempus porttitor. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Ligula Elit Quam Pellentesque|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Curabitur blandit tempus porttitor.|g2n||g2n|Sed posuere consectetur est at lobortis. Curabitur blandit tempus porttitor. Cras mattis consectetur purus sit amet fermentum. Curabitur blandit tempus porttitor.|g2n||g2n|Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Curabitur blandit tempus porttitor. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Adipiscing Sollicitudin Bibendum Ipsum|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nullam quis risus eget urna mollis ornare vel eu leo. Donec sed odio dui. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Donec ullamcorper nulla non metus auctor fringilla.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Vestibulum id ligula porta felis euismod semper.|g2n||g2n|Donec ullamcorper nulla non metus auctor fringilla. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Condimentum Vulputate Ornare|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nullam quis risus eget urna mollis ornare vel eu leo. Donec sed odio dui. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Donec ullamcorper nulla non metus auctor fringilla.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Vestibulum id ligula porta felis euismod semper.|g2n||g2n|Donec ullamcorper nulla non metus auctor fringilla. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas faucibus mollis interdum.|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Dolor Sem Ultricies Tortor Ipsum|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Nullam quis risus eget urna mollis ornare vel eu leo. Donec sed odio dui. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Maecenas faucibus mollis interdum. Donec id elit non mi porta gravida at eget metus. Cras mattis consectetur purus sit amet fermentum. Donec ullamcorper nulla non metus auctor fringilla.|g2n||g2n|Nullam quis risus eget urna mollis ornare vel eu leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Morbi leo risus, porta ac consectetur ac, vestibulum at eros. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Vestibulum id ligula porta felis euismod semper.|g2n||g2n|Donec ullamcorper nulla non metus auctor fringilla. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas faucibus mollis interdum.|gq2|}]","title-type":"none","icon":"","title":"","caption":"","initial-state":"0","style":"style-1","margin-bottom":"80px"}}]',
					'post-option'=>'{"sidebar":"right-sidebar","left-sidebar":"Footer 1","right-sidebar":"Features","page-style":"normal","show-title":"enable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'service' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[]',
					'content-with-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Feature Media","type":"feature-media","option":{"page-item-id":"","type":"video","video-url":"http://vimeo.com/86823427","image":"2271","thumbnail-size":"full","title":"Presentation Video","caption":"","content":"Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero, a pharetra augue. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Nullam quis risus eget urna mollis ornare vel eu leo. Nulla vitae elit libero.","button-text":"Learn More","button-link":"#","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2274","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","border":"none","border-top-color":"#dddddd","border-bottom-color":"#dddddd","padding-top":"110px","padding-bottom":"60px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","icon":"","title":"What We Can Do","caption":"Example of service page","right-text":"Read More","right-text-link":"","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#f3f3f3","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"90px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-trophy","image":"","thumbnail-size":"","title":"Work With Champion","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excepteur sint obcaecat cupiditat non proident culpa.","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-edit","image":"","thumbnail-size":"thumbnail","title":"Great Business Plan","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excep teur sint obcaecat cupiditat.","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-cloud","image":"","thumbnail-size":"thumbnail","title":"Like A Boss","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excep teur sint obcaecat cupiditat.","margin-bottom":"60px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-signal","image":"","thumbnail-size":"thumbnail","title":"Grow Your Business","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excep teur sint obcaecat cupiditat.","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-comment","image":"","thumbnail-size":"thumbnail","title":"Great Feedbacks","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excep teur sint obcaecat cupiditat.","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-truck","image":"","thumbnail-size":"thumbnail","title":"We Go Everywhere","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excep teur sint obcaecat cupiditat.","margin-bottom":"70px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"type-1","icon":"icon-user","image":"","thumbnail-size":"","title":"Top Notch Support","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excepteur sint obcaecat cupiditat non proident culpa.","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"","icon":"icon-off","image":"","thumbnail-size":"","title":"Powerful Team","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excepteur sint obcaecat cupiditat non proident culpa.","margin-bottom":"60px"}},{"item-type":"item","item-builder-title":"Column Service","type":"column-service","option":{"page-item-id":"","style":"","icon":"icon-wrench","image":"","thumbnail-size":"","title":"Fast Service","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Excepteur sint obcaecat cupiditat non proident culpa.","margin-bottom":"60px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","background":"#ffffff","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"115px","padding-bottom":"10px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[],"option":{"page-item-id":"","type":"image","background":"2855","background-speed":"0.1","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"450px","padding-bottom":"40px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Title","type":"title","option":{"page-item-id":"","title-type":"center","icon":"","title":"Friendly Pricing","caption":"Donec ullamcorper nulla non metus auctor fringilla.","right-text":"Read More","right-text-link":"","margin-bottom":"100px"}},{"item-type":"item","item-builder-title":"Price Table","type":"price-table","option":{"page-item-id":"","price-table":"[{|gq2|gdl-tab-title|gq2|:|gq2|Basic|gq2|,|gq2|gdl-tab-price|gq2|:|gq2|$29.99/mo|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|<ul>|g2n||g2t|<li>30 GB</li>|g2n||g2t|<li>12 Email Accounts</li>|g2n||g2t|<li>50 GB Bandwidth</li>|g2n||g2t|<li>Live Chat Support</li>|g2n||g2t|<li>Enchanced SSL Security</li>|g2n|</ul>|gq2|,|gq2|gdl-tab-active|gq2|:|gq2|no|gq2|,|gq2|gdl-tab-link|gq2|:|gq2|#|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Deluxe|gq2|,|gq2|gdl-tab-price|gq2|:|gq2|$39.99/mo|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|<ul>|g2n||g2t|<li>30 GB</li>|g2n||g2t|<li>12 Email Accounts</li>|g2n||g2t|<li>50 GB Bandwidth</li>|g2n||g2t|<li>Live Chat Support</li>|g2n||g2t|<li>Enchanced SSL Security</li>|g2n|</ul>|gq2|,|gq2|gdl-tab-active|gq2|:|gq2|no|gq2|,|gq2|gdl-tab-link|gq2|:|gq2|#|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Premium|gq2|,|gq2|gdl-tab-price|gq2|:|gq2|$49.99/mo|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|<ul>|g2n||g2t|<li>30 GB</li>|g2n||g2t|<li>12 Email Accounts</li>|g2n||g2t|<li>50 GB Bandwidth</li>|g2n||g2t|<li>Live Chat Support</li>|g2n||g2t|<li>Enchanced SSL Security</li>|g2n|</ul>|gq2|,|gq2|gdl-tab-active|gq2|:|gq2|yes|gq2|,|gq2|gdl-tab-link|gq2|:|gq2|#|gq2|},{|gq2|gdl-tab-title|gq2|:|gq2|Advanc|gq2|,|gq2|gdl-tab-price|gq2|:|gq2|$59.99/mo|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|<ul>|g2n||g2t|<li>30 GB</li>|g2n||g2t|<li>12 Email Accounts</li>|g2n||g2t|<li>50 GB Bandwidth</li>|g2n||g2t|<li>Live Chat Support</li>|g2n||g2t|<li>Enchanced SSL Security</li>|g2n|</ul>|gq2|,|gq2|gdl-tab-active|gq2|:|gq2|no|gq2|,|gq2|gdl-tab-link|gq2|:|gq2|#|gq2|}]","columns":"4","margin-bottom":"0px"}}],"option":{"page-item-id":"","background":"#f3f3f3","skin":"no-skin","border":"none","border-top-color":"#dddddd","border-bottom-color":"#dddddd","padding-top":"90px","padding-bottom":"100px"}},{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"item","item-builder-title":"Testimonial","type":"testimonial","option":{"page-item-id":"","testimonial":"[{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|John Doe|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Architexture|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla c onsectetur. Morbi leo risus, porta ac consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Marry Jones|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|Accountant|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla c onsectetur. Morbi leo risus, porta ac consectetur.|gq2|},{|gq2|gdl-tab-author-image-url|gq2|:|gq2||gq2|,|gq2|gdl-tab-author-image|gq2|:|gq2||gq2|,|gq2|gdl-tab-title|gq2|:|gq2|Dave Keith|gq2|,|gq2|gdl-tab-position|gq2|:|gq2|General Manager|gq2|,|gq2|gdl-tab-content|gq2|:|gq2|Sed posuere consectetur est at lobortis. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla c onsectetur. Morbi leo risus, porta ac consectetur.|gq2|}]","title-type":"quote","icon":"","title":"","caption":"","testimonial-columns":"2","testimonial-type":"carousel","testimonial-style":"large plain-style","margin-bottom":"20px"}}],"option":{"page-item-id":"","type":"image","background":"2110","background-speed":"0.3","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"gdlr-skin-dark-testimonial","border":"none","border-top-color":"#e9e9e9","border-bottom-color":"#e9e9e9","padding-top":"100px","padding-bottom":"70px"}},{"item-type":"wrapper","item-builder-title":"Color Wrapper","type":"color-wrapper","items":[{"item-type":"item","item-builder-title":"Stunning Text","type":"stunning-text","option":{"page-item-id":"","title":"Feel Interested Now?","caption":"","button-text":"Hire Us!","button-link":"#","style":"center","margin-bottom":"20px"}}],"option":{"page-item-id":"","background":"#f3f3f3","skin":"gdlr-skin-light-gray-skin","border":"none","border-top-color":"#dba40f","border-bottom-color":"#e9e9e9","padding-top":"75px","padding-bottom":"30px"}}]',
					'post-option'=>'{"sidebar":"no-sidebar","left-sidebar":"blog","right-sidebar":"blog","page-style":"normal","show-title":"disable","page-caption":"","show-content":"disable","header-background":""}'
				),
				'contact-1' => array(
					'above-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"<iframe src=|gq2|http://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=seattle&amp;aq=&amp;sll=22.447841,114.109497&amp;sspn=0.448038,0.550003&amp;vpsrc=0&amp;ie=UTF8&amp;hq=&amp;hnear=%E0%B8%8B%E0%B8%B5%E0%B9%81%E0%B8%AD%E0%B8%95%E0%B9%80%E0%B8%97%E0%B8%B4%E0%B8%A5+King,+%E0%B8%A3%E0%B8%B1%E0%B8%90%E0%B8%A7%E0%B8%AD%E0%B8%8A%E0%B8%B4%E0%B8%87%E0%B8%95%E0%B8%B1%E0%B8%99+%E0%B8%AA%E0%B8%AB%E0%B8%A3%E0%B8%B1%E0%B8%90%E0%B8%AD%E0%B9%80%E0%B8%A1%E0%B8%A3%E0%B8%B4%E0%B8%81%E0%B8%B2&amp;t=m&amp;z=12&amp;ll=47.60621,-122.332071&amp;output=embed|gq2| height=|gq2|470|gq2| width=|gq2|100%|gq2| frameborder=|gq2|0|gq2| marginwidth=|gq2|0|gq2| marginheight=|gq2|0|gq2| scrolling=|gq2|no|gq2|></iframe>|g1n|[gdlr_space height=|gq2|-26px|gq2|]","margin-bottom":"0px"}}],"option":{"page-item-id":"","border":"none","border-top-color":"#dddddd","border-bottom-color":"#dddddd","padding-top":"0px","padding-bottom":"0px"}}]',
					'below-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Background/Parallax Wrapper","type":"parallax-bg-wrapper","items":[{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Box Icon","type":"box-icon-item","option":{"page-item-id":"","icon":"icon-envelope","icon-position":"top","icon-type":"circle","icon-color":"#ffffff","icon-background":"#e2714d","title":"Contact By Email","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-2","items":[{"item-type":"item","item-builder-title":"Box Icon","type":"box-icon-item","option":{"page-item-id":"","icon":"icon-phone-sign","icon-position":"top","icon-type":"circle","icon-color":"#ffffff","icon-background":"#e2714d","title":"Contact By Phone","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.","margin-bottom":"20px"}}],"option":{},"size":"1/3"},{"item-type":"wrapper","item-builder-title":"Column Item","type":"column1-3","items":[{"item-type":"item","item-builder-title":"Box Icon","type":"box-icon-item","option":{"page-item-id":"","icon":"icon-home","icon-position":"top","icon-type":"circle","icon-color":"#ffffff","icon-background":"#e2714d","title":"Come To See Us","content":"Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.","margin-bottom":"20px"}}],"option":{},"size":"1/3"}],"option":{"page-item-id":"","type":"image","background":"2878","background-speed":"0.2","pattern":"1","video":"","video-overlay":"0.5","video-player":"enable","skin":"no-skin","border":"none","border-top-color":"#dddddd","border-bottom-color":"#dddddd","padding-top":"100px","padding-bottom":"50px"}}]',
					'content-with-sidebar'=>'[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_heading tag=|gq2|h3|gq2| font_weight=|gq2|bold|gq2| ]Talk to us![/gdlr_heading]|g1n||g1n|[gdlr_space height=|gq2|45px|gq2|]|g1n||g1n|[contact-form-7 id=|gq2|4|gq2| title=|gq2|Contact form 1|gq2|]","margin-bottom":"60px"}}]',
					'post-option'=>'{"sidebar":"right-sidebar","left-sidebar":"Footer 1","right-sidebar":"contact","page-style":"normal","navigation-area":"top","show-title":"disable","page-caption":"","show-content":"enable","header-background":""}'
				),
				'contact-2' => array(
					'above-sidebar'=>'[]',
					'below-sidebar'=>'[{"item-type":"wrapper","item-builder-title":"Full Size Wrapper","type":"full-size-wrapper","items":[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"<iframe src=|gq2|http://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=seattle&amp;aq=&amp;sll=22.447841,114.109497&amp;sspn=0.448038,0.550003&amp;vpsrc=0&amp;ie=UTF8&amp;hq=&amp;hnear=%E0%B8%8B%E0%B8%B5%E0%B9%81%E0%B8%AD%E0%B8%95%E0%B9%80%E0%B8%97%E0%B8%B4%E0%B8%A5+King,+%E0%B8%A3%E0%B8%B1%E0%B8%90%E0%B8%A7%E0%B8%AD%E0%B8%8A%E0%B8%B4%E0%B8%87%E0%B8%95%E0%B8%B1%E0%B8%99+%E0%B8%AA%E0%B8%AB%E0%B8%A3%E0%B8%B1%E0%B8%90%E0%B8%AD%E0%B9%80%E0%B8%A1%E0%B8%A3%E0%B8%B4%E0%B8%81%E0%B8%B2&amp;t=m&amp;z=12&amp;ll=47.60621,-122.332071&amp;output=embed|gq2| height=|gq2|360|gq2| width=|gq2|100%|gq2| frameborder=|gq2|0|gq2| marginwidth=|gq2|0|gq2| marginheight=|gq2|0|gq2| scrolling=|gq2|no|gq2|></iframe> [gdlr_space height=|gq2|-26px|gq2|]","margin-bottom":"0px"}}],"option":{"page-item-id":"","border":"top","border-top-color":"#d8d8d8","border-bottom-color":"#dddddd","padding-top":"0px","padding-bottom":"0px"}}]',
					'content-with-sidebar'=>'[{"item-type":"item","item-builder-title":"Content","type":"content","option":{"page-item-id":"","title-type":"none","icon":"","title":"","caption":"","content":"[gdlr_heading tag=|gq2|h3|gq2| font_weight=|gq2|bold|gq2| ]Talk to us![/gdlr_heading]|g1n||g1n|[gdlr_space height=|gq2|45px|gq2|]|g1n||g1n|[contact-form-7 id=|gq2|4|gq2| title=|gq2|Contact form 1|gq2|]","margin-bottom":"60px"}}]',
					'post-option'=>'{"sidebar":"left-sidebar","left-sidebar":"contact","right-sidebar":"contact","page-style":"normal","navigation-area":"top","show-title":"enable","page-caption":"","show-content":"enable","header-background":""}'
				),					
			);

			$loaded_data = $default_data[$_POST['slug']];
			foreach( $loaded_data as $meta_key => $meta_value ){
				update_post_meta($_POST['post_id'], $meta_key, $meta_value);
			}
		}
	}
?>